#!/bin/sh
# /opt/Mahr/ps10/create_backing_storage.sh
BS=/tmp/bs.vfat
MP=/media/backing

# A = 'PS10', 'ST2', 'M310', 'M410' or ''
A=$(sed -nr "/^\[general\]/,/^\[/{ :l /^machine[ ]*=/ { s/.*=[ ]*//; p; q;}; n; b l;}" /var/opt/Mahr/ps10/ps10tool.ini)
PRODUCT="MarSurf"
if [ "$A" == "ST2" ]; then
	PRODUCT="GARANT "
fi

if [ "_$A" == "_" ]; then
    A="PS10"
fi

mkdir -p ${MP}

if [ ! -e ${BS} ]; then
	dd if=/dev/zero of=${BS} bs=1M count=200
	mkfs.vfat -n "${PRODUCT}${A}" ${BS}
	mount -t vfat -o loop ${BS} ${MP}

	if [ -d /usr/share/ps10/windows_driver_files ]; then
		cp -r /usr/share/ps10/windows_driver_files ${MP}
	fi
fi
